/*
---
Description: Lighter.js - Syntax Highlighter written in MooTools.

License: MIT-style license

Authors:
- Jose Prado

Copyright:
- Copyright (©) 2009 [Jose Prado](http://pradador.com/)

Dependencies:
- MooTools-Core
...
*/

var Lighter=new Class({Implements:[Options],name:"Lighter",options:{altLines:"",container:null,editable:false,flame:"standard",fuel:"standard",id:null,indent:-1,jsStyles:true,matchType:"standard",mode:"pre",path:"./",strict:false},initialize:function(c,b){this.setOptions(b);b=this.options;this.id=b.id||this.name+"_"+$time();this.codeblock=$(c);this.code=c.get("html").chop().replace(/&lt;/gim,"<").replace(/&gt;/gim,">").replace(/&amp;/gim,"&");this.container=$(this.options.container);if(b.indent>-1){this.code=this.code.tabToSpaces(b.indent)}this.builder=new Hash({pre:this.createLighter.bind(this),ol:this.createLighterWithLines.pass([["ol"],["li"]],this),div:this.createLighterWithLines.pass([["div"],["div","span"],true,"span"],this),table:this.createLighterWithLines.pass([["table","tbody"],["tr","td"],true,"td"],this)});var a=this.codeblock.get("class").split(":");if(!a[0]){a[0]=this.options.fuel}if(!a[1]){a[1]=this.options.flame}this.loadFlameSrc(a)},loadFlameSrc:function(b){if(!$chk(Flame[b[1]])){var a=new Element("script",{src:this.options.path+"Flame."+b[1]+".js",type:"text/javascript"}).addEvents({load:function(){this.loadFlame(b)}.bind(this),error:function(){b[1]="standard";this.loadFlame(b)}.bind(this)}).inject(document.head)}else{this.loadFlame(b)}},loadFlame:function(a){this.flame=new Flame[a[1]](this);this.loadFuelSrc(a)},loadFuelSrc:function(a){if(!$chk(Fuel[a[0]])){var b=new Element("script",{src:this.options.path+"Fuel."+a[0]+".js",type:"text/javascript"}).addEvents({load:function(){this.loadFuel(a)}.bind(this),error:function(){a[0]="standard";this.loadFuel(a)}.bind(this)}).inject(document.head)}else{this.loadFuel(a)}},loadFuel:function(a){this.fuel=new Fuel[a[0]](this,this.flame,{matchType:this.options.matchType,strict:this.options.strict});this.light()},light:function(){this.element=this.toElement();if(this.container){this.container.empty();this.element.inject(this.container)}else{this.codeblock.setStyle("display","none");this.element.inject(this.codeblock,"after")}},createLighter:function(){var a=new Element("pre",{"class":this.flame.shortName+this.name}),b=0;if(!$defined(this.fuel.wicks[0])){a.appendText(this.code)}else{this.fuel.wicks.each(function(c){a.appendText(this.code.substring(b,c.index));this.insertAndKeepEl(a,c.text,c.type);b=c.index+c.text.length},this);if(b<this.code.length){a.appendText(this.code.substring(b,this.code.length))}}return a},createLighterWithLines:function(h,b,d,c){var k=new Element(h[0],{"class":this.flame.shortName+this.name,id:this.id}),g=new Element(b[0]),f=1,a=0,j=null;if(h[0]=="table"){k.set("cellpadding",0).set("cellspacing",0).set("border",0)}if(h[1]){k=new Element(h[1]).inject(k)}if(b[1]){g=new Element(b[1]).inject(g)}g.addClass(this.flame.shortName+"line");if(d){f=this.insertLineNum(g,f,c)}this.fuel.wicks.each(function(l){if(a!=l.index){j=this.code.substring(a,l.index).split("\n");for(var m=0;m<j.length;m++){if(m<j.length-1){if(j[m]==""){j[m]=" "}g=this.insertAndMakeEl(g,k,j[m],b);if(d){f=this.insertLineNum(g,f,c)}}else{this.insertAndKeepEl(g,j[m])}}}j=l.text.split("\n");for(m=0;m<j.length;m++){if(m<j.length-1){g=this.insertAndMakeEl(g,k,j[m],b,l.type);if(d){f=this.insertLineNum(g,f,c)}}else{this.insertAndKeepEl(g,j[m],l.type)}}a=l.end},this);if(a<=this.code.length){j=this.code.substring(a,this.code.length).split("\n");for(var e=0;e<j.length;e++){g=this.insertAndMakeEl(g,k,j[e],b);if(d){f=this.insertLineNum(g,f,c)}}}if(this.options.altLines!==""){if(this.options.altLines=="hover"){k.getElements("."+this.flame.shortName+"line").addEvents({mouseover:function(){this.toggleClass("alt")},mouseout:function(){this.toggleClass("alt")}})}else{if(b[1]){k.getChildren(":"+this.options.altLines).getElement("."+this.flame.shortName+"line").addClass("alt")}else{k.getChildren(":"+this.options.altLines).addClass("alt")}}}if(b[1]){k.getFirst().getChildren().addClass(this.flame.shortName+"first");k.getLast().getChildren().addClass(this.flame.shortName+"last")}else{k.getFirst().addClass(this.flame.shortName+"first");k.getLast().addClass(this.flame.shortName+"last")}if(h[1]){k=k.getParent()}return k},insertAndKeepEl:function(c,d,a){if(d.length>0){var b=new Element("span");b.set("text",d);if(a){b.addClass(this.flame.aliases[a])}b.inject(c)}},insertAndMakeEl:function(b,c,d,f,a){this.insertAndKeepEl(b,d,a);if(f[1]){b=b.getParent()}b.inject(c);var e=new Element(f[0]);if(f[1]){e=new Element(f[1]).inject(e)}e.addClass(this.flame.shortName+"line");return e},insertLineNum:function(b,d,a){var c=new Element(a,{text:d++,"class":this.flame.shortName+"num"});c.inject(b.getParent(),"top");return d},toElement:function(){if(!this.element){this.element=this.builder[this.options.mode]();if(this.options.editable){this.element.set("contenteditable","true")}}return this.element},replaces:function(a){a=$(a,true);a.parentNode.replaceChild(this.toElement(),a);return this}});Element.implement({light:function(a){return new Lighter(this,a)}});String.implement({chop:function(){return this.replace(/(^\s*\n|\n\s*$)/gi,"")},tabToSpaces:function(b){for(var c=0,a="";c<b;c++){a+=" "}return this.replace(/\t/g,a)}});var Fuel=new Class({Implements:[Options],options:{matchType:"standard",strict:false},language:"",defaultFlame:"standard",patterns:new Hash(),keywords:new Hash(),rules:new Hash(),delimiters:new Hash({start:null,end:null}),common:{slashComments:/(?:^|[^\\])\/\/.*$/gm,poundComments:/#.*$/gm,multiComments:/\/\*[\s\S]*?\*\//gm,aposStrings:/'[^'\\]*(?:\\.[^'\\]*)*'/gm,quotedStrings:/"[^"\\]*(?:\\.[^"\\]*)*"/gm,strings:/'[^'\\]*(?:\\.[^'\\]*)*'|"[^"\\]*(?:\\.[^"\\]*)*"/gm,properties:/\.([\w]+)\s*/gi,methodCalls:/\.([\w]+)\s*\(/gm,functionCalls:/\b([\w]+)\s*\(/gm,brackets:/\{|\}|\(|\)|\[|\]/g,numbers:/\b((?:(\d+)?\.)?[0-9]+|0x[0-9A-F]+)\b/gi},initialize:function(j,i,k,h){this.setOptions(k);this.wicks=h||[];this.lighter=j;this.flame=i;this.builder=new Hash({standard:this.findMatches,lazy:this.findMatchesLazy});if(!k.strict){if(this.delimiters.start){this.addFuel("delimBeg",this.delimiters.start,"de1")}if(this.delimiters.end){this.addFuel("delimEnd",this.delimiters.end,"de2")}}this.keywords.each(function(m,l){if(m.csv!=""){this.addFuel(l,this.csvToRegExp(m.csv,"g"),m.alias)}},this);this.patterns.each(function(l,m){this.addFuel(m,l.pattern,l.alias)},this);var g=0,a=j.code.length,c="",b=this.delimiters,f=[],e=null,d=null;if(!k.strict){f.extend(this.builder[k.matchType].pass(j.code,this)())}else{if(b.start&&b.end){while((e=b.start.exec(j.code))!=null){b.end.lastIndex=b.start.lastIndex;if((d=b.end.exec(j.code))!=null){f.push(new Wick(e[0],"de1",e.index));g=b.start.lastIndex;a=d.index-1;c=j.code.substring(g,a);f.extend(this.builder[k.matchType].pass([c,g],this)());f.push(new Wick(d[0],"de2",d.index))}}}}this.wicks=f},addFuel:function(c,a,b){this.rules[c]=a;this.flame.addAlias(c,b)},csvToRegExp:function(a,b){return new RegExp("\\b("+a.replace(/,\s*/g,"|")+")\\b",b)},delimToRegExp:function(c,b,a,d,e){c=c.escapeRegExp();if(b){b=b.escapeRegExp()}a=(a)?a.escapeRegExp():c;pat=(b)?c+"[^"+a+b+"\\n]*(?:"+b+".[^"+a+b+"\\n]*)*"+a:c+"[^"+a+"\\n]*"+a;return new RegExp(pat+(e||""),d||"")},strictRegExp:function(){var b="(";for(var a=0;a<arguments.length;a++){b+=arguments[a].escapeRegExp();b+=(a<arguments.length-1)?"|":""}b+=")";return new RegExp(b,"gim")},findMatches:function(d,f){var b=[],e=0,a=d.length;insertIndex=0,match=null,type=null,newWick=null,rule=null,rules={},currentMatch=null,futureMatch=null;f=f||0;this.rules.each(function(g,h){rules[h]={pattern:g,lastIndex:0}},this);while(e<d.length){a=d.length;match=null;for(rule in rules){rules[rule].pattern.lastIndex=e;currentMatch=rules[rule].pattern.exec(d);if(currentMatch===null){delete rules[rule]}else{if(currentMatch.index<a||(currentMatch.index==a&&match[0].length<currentMatch[0].length)){match=currentMatch;type=rule;a=currentMatch.index}rules[rule].nextIndex=rules[rule].pattern.lastIndex-currentMatch[0].length}}if(match!=null){index=(match[1]&&match[0].contains(match[1]))?match.index+match[0].indexOf(match[1]):match.index;newWick=new Wick(match[1]||match[0],type,index+f);b.push(newWick);futureMatch=rules[type].pattern.exec(d);if(!futureMatch){rules[type].nextIndex=d.length}else{rules[type].nextIndex=rules[type].pattern.lastIndex-futureMatch[0].length}var c=d.length;for(rule in rules){if(rules[rule].nextIndex<c){c=rules[rule].nextIndex}}e=Math.max(c,newWick.end-f)}else{break}}return b},findMatchesLazy:function(c,d){var a=this.wicks,b=null;index=0;d=d||0;this.rules.each(function(e,f){while((b=e.exec(c))!=null){index=(b[1]&&b[0].contains(b[1]))?b.index+b[0].indexOf(b[1]):b.index;a.push(new Wick(b[1]||b[0],f,index+d))}},this);return this.purgeWicks(a)},purgeWicks:function(a){a=a.sort(this.compareWicks);for(var c=0,b=0;c<a.length;c++){if(a[c]==null){continue}for(b=c+1;b<a.length&&a[c]!=null;b++){if(a[b]==null){continue}else{if(a[b].isBeyond(a[c])){break}else{if(a[b].overlaps(a[c])){a[c]=null}else{if(a[c].contains(a[b])){a[b]=null}}}}}}return a.clean()},compareWicks:function(b,a){return b.index-a.index}});Fuel.standard=new Class({Extends:Fuel,initialize:function(a,d,c,b){this.parent(a,d,c,b)}});var Wick=new Class({initialize:function(b,c,a){this.text=b;this.type=c;this.index=a;this.length=this.text.length;this.end=this.index+this.length},contains:function(a){return(a.index>=this.index&&a.index<this.end)},isBeyond:function(a){return(this.index>=a.end)},overlaps:function(a){return(this.index==a.index&&this.length>a.length)},toString:function(){return this.index+" - "+this.text+" - "+this.end}});var Flame=new Class({shortName:"lt",aliases:new Hash(),common:new Hash(),layout:new Hash(),styles:new Hash(),defaultCommon:new Hash({"font-family":"Monaco, Courier, Monospace","font-size":"12px","line-height":"1.5",overflow:"auto","white-space":"pre-wrap","word-wrap":"break-word"}),defaultLayout:new Hash({numBgColor:new Hash(),lineBgColor:new Hash(),lineNumStyles:new Hash(),lineStyles:new Hash(),altLineStyles:new Hash(),top:new Hash(),right:new Hash(),bottom:new Hash(),left:new Hash(),codeStyles:new Hash()}),fixes:new Hash({div:new Hash({div:new Hash({clear:"left",overflow:"auto"}),num:new Hash({display:"block","float":"left","text-align":"center",width:"30px"}),line:new Hash({display:"block","margin-left":"30px"})}),table:new Hash({num:new Hash({"text-align":"center",width:"30px"})}),ol:new Hash({ol:new Hash({"margin-top":"0","margin-bottom":"0","margin-left":"0","padding-left":"0"}),li:new Hash({"margin-left":"40px"})})}),initialize:function(a,b){this.lighter=a;this.fuel=b;this.common.combine(this.defaultCommon);this.layout.combine(this.defaultLayout);this.styles.each(function(d,c){this.addAlias(c)},this);if(this.lighter.options.jsStyles){this.injectTag()}},addAlias:function(b,a){this.aliases[b]=a||b},injectTag:function(){this.styleTag=new Element("style").setProperty("type","text/css").inject(document.head);this.styleText="";var c=this.lighter.options.mode,f=c+"."+this.shortName+this.lighter.name,d=f+" ."+this.shortName,b=this.layout.lineNumStyles.extend(this.layout.numBgColor),a=this.layout.lineStyles.extend(this.layout.lineBgColor),e=this.layout.left.extend(this.layout.right);this.addCSS(f,this.common);this.addCSS(f,new Hash({"white-space":"-moz-pre-wrap"}));this.addCSS(f,new Hash({"white-space":"-pre-wrap"}));this.addCSS(f,new Hash({"white-space":"-o-pre-wrap"}));switch(c){case"pre":e=e.extend(this.layout.top).extend(this.layout.bottom);this.addCSS(f,this.layout.lineBgColor.extend(e));this.addCSS(f+" span",this.layout.codeStyles);break;case"ol":this.addCSS(f,b.extend(this.fixes.ol["ol"]));this.addCSS(f+" li",a.extend(e).extend(this.fixes.ol["li"]));this.addCSS(d+"first",this.layout.top);this.addCSS(d+"last",this.layout.bottom);this.addCSS(f+" .alt",this.layout.altLineStyles);this.addCSS(f+" span",this.layout.codeStyles);break;case"div":this.addCSS(d+"num",b.extend(this.fixes.div.num));this.addCSS(d+"line",a.extend(e).extend(this.fixes.div.line));this.addCSS(f+" div",this.fixes.div["div"].extend(this.layout.numBgColor));this.addCSS(d+"first",this.layout.top);this.addCSS(d+"last",this.layout.bottom);this.addCSS(f+" .alt",this.layout.altLineStyles);this.addCSS(f+" span",this.layout.codeStyles);break;case"table":this.addCSS(d+"num",b.extend(this.fixes.table["num"]));this.addCSS(d+"line",a.extend(e));this.addCSS(d+"first",this.layout.top);this.addCSS(d+"last",this.layout.bottom);this.addCSS(f+" .alt",this.layout.altLineStyles);this.addCSS(f+" span",this.layout.codeStyles);break}this.styles.each(function(g,h){this.addCSS(f+" ."+h,g)},this);if(Browser.Engine.trident){this.styleTag.styleSheet.cssText+=this.styleText}else{this.styleTag.appendText(this.styleText)}},addCSS:function(b,a){var c="\n"+b+" {\n";if(a){a.each(function(e,d){c+="\t"+d+": "+e+";\n"})}c+="}\n";this.styleText+=c}});Flame.standard=new Class({Extends:Flame,styles:new Hash({de1:new Hash({}),de2:new Hash({}),kw1:new Hash({color:"#1b609a"}),kw2:new Hash({color:"#9a6f1b"}),kw3:new Hash({color:"#784e0c"}),kw4:new Hash({color:"#9a6f1b"}),co1:new Hash({color:"#888888"}),co2:new Hash({color:"#888888"}),st0:new Hash({color:"#489a1b"}),st1:new Hash({color:"#489a1b"}),st2:new Hash({color:"#489a1b"}),nu0:new Hash({color:"#70483d"}),me0:new Hash({color:"#666666"}),br0:new Hash({color:"#444444"}),sy0:new Hash({color:"#444444"}),es0:new Hash({color:"#444444"}),re0:new Hash({color:"#784e0c"})}),layout:new Hash({numBgColor:new Hash({"background-color":"#f2f2f2"}),lineBgColor:new Hash({"background-color":"#fff"}),lineNumStyles:new Hash({color:"#939393","font-size":"10px","list-style":"decimal-leading-zero"}),lineStyles:new Hash({"border-top":"1px solid #fff","border-bottom":"1px solid #fff","border-left":"1px solid #939393",padding:"0 3px 0 10px"}),altLineStyles:new Hash({"border-top":"1px solid #eee","border-bottom":"1px solid #eee","background-color":"#F4F8FC"}),top:new Hash({"padding-top":"5px"}),right:new Hash({"padding-right":"5px"}),bottom:new Hash({"padding-bottom":"5px"}),left:new Hash({"padding-left":"15px"}),codeStyles:new Hash({color:"black","font-size":"12px"})}),initialize:function(a,b){this.parent(a,b)}});
Fuel.js=new Class({Extends:Fuel,language:"js",initialize:function(a,c,b){this.keywords=new Hash({commonKeywords:{csv:"as, break, case, catch, continue, delete, do, else, eval, finally, for, if, in, is, item, instanceof, return, switch, this, throw, try, typeof, void, while, write, with",alias:"kw1"},langKeywords:{csv:"class, const, default, debugger, export, extends, false, function, import, namespace, new, null, package, private, protected, public, super, true, use, var",alias:"kw2"},windowKeywords:{csv:"alert, back, blur, close, confirm, focus, forward, home, navigate, onblur, onerror, onfocus, onload, onmove, onresize, onunload, open, print, prompt, scroll, status, stop",alias:"kw3"}});this.patterns=new Hash({slashComments:{pattern:this.common.slashComments,alias:"co1"},multiComments:{pattern:this.common.multiComments,alias:"co2"},strings:{pattern:this.common.strings,alias:"st0"},methodCalls:{pattern:this.common.properties,alias:"me0"},brackets:{pattern:this.common.brackets,alias:"br0"},numbers:{pattern:/\b((([0-9]+)?\.)?[0-9_]+([e][-+]?[0-9]+)?|0x[A-F0-9]+)\b/gi,alias:"nu0"},regex:{pattern:this.delimToRegExp("/","\\","/","g","[gimy]*"),alias:"re0"},symbols:{pattern:/\+|-|\*|\/|%|!|@|&|\||\^|\<|\>|=|,|\.|;|\?|:/g,alias:"sy0"}});this.delimiters=new Hash({start:this.strictRegExp('<script type="text/javascript">','<script language="javascript">'),end:this.strictRegExp("<\/script>")});this.parent(a,c,b)}});
Fuel.html=new Class({Extends:Fuel,language:"html",initialize:function(h,g,i){i.matchType="lazy";this.patterns=new Hash({comments:{pattern:/(?:\&lt;|<)!--[\s\S]*?--(?:\&gt;|>)/gim,alias:"co1"},cdata:{pattern:/(?:\&lt;|<)!\[CDATA\[[\s\S]*?\]\](?:\&gt;|>)/gim,alias:"st1"},closingTags:{pattern:/(?:\&lt;|<)\/[A-Z][A-Z0-9]*?(?:\&gt;|>)/gi,alias:"kw1"},doctype:{pattern:/(?:\&lt;|<)!DOCTYPE[\s\S]+?(?:\&gt;|>)/gim,alias:"st2"}});var a=/((?:\&lt;|<)[A-Z][A-Z0-9]*)(.*?)(\/?(?:\&gt;|>))/gi,f=/\b([\w-]+)([ \t]*)(=)([ \t]*)(['"][^'"]+['"]|[^'" \t]+)/gi,c=[],d=null,b=null,e=0;while((d=a.exec(h.code))!=null){c.push(new Wick(d[1],"kw1",d.index));while((b=f.exec(d[2]))!=null){e=d.index+d[1].length+b.index;c.push(new Wick(b[1],"kw2",e));e+=b[1].length+b[2].length;c.push(new Wick(b[3],"kw1",e));e+=b[3].length+b[4].length;c.push(new Wick(b[5],"kw3",e))}c.push(new Wick(d[3],"kw1",d.index+d[1].length+d[2].length))}this.parent(h,g,i,c)}});
Fuel.css=new Class({Extends:Fuel,language:"css",initialize:function(a,c,b){this.keywords=new Hash({css1:{csv:"background-attachment, background-color, background-image, background-position, background-repeat, background, border-bottom, border-bottom-width, border-color, border-left, border-left-width, border-right, border-right-width, border-style, border-top, border-top-width, border-width, border, clear, color, display, float, font-family, font-size, font-style, font-variant, font-weight, font, height, letter-spacing, line-height, list-style-image, list-style-position, list-style-type, list-style, margin-bottom, margin-left, margin-right, margin-top, margin, padding-bottom, padding-left, padding-right, padding-top, padding, text-align, text-decoration, text-indent, text-transform, vertical-align, white-space, width, word-spacing",alias:"kw1"},css2:{csv:"azimuth, border-bottom-color, border-bottom-style, border-collapse, border-left-color, border-left-style, border-right-color, border-right-style, border-spacing, border-top-color, border-top-style, bottom, caption-side, clip, content, counter-increment, counter-reset, cue, cue-after, cue-before, cursor, direction, elevation, empty-cells, left, max-height, max-width, min-height, min-width, orphans, outline, outline-color, outline-style, outline-width, overflow, page-break-after, page-break-before, page-break-inside, pause, pause-after, pause-before, pitch, pitch-range, play-during, position, quotes, richness, right, speak, speak-header, speak-numeral, speak-punctuation, speech-rate, stress, table-layout, top, unicode-bidi, visibility, voice-family, volume, widows, z-index",alias:"kw1"},css3:{csv:"alignment-adjust, alignment-baseline, appearance, background-break, background-clip, background-origin, background-size, baseline-shift, binding, bookmark-label, bookmark-level, bookmark-target, border-bottom-left-radius, border-bottom-right-radius, border-break, border-image, border-length, border-radius, border-top-left-radius, border-top-right-radius, box-align, box-direction, box-flex, box-flex-group, box-lines, box-orient, box-pack, box-shadow, box-sizing, color-profile, column-break-after, column-break-before, column-count, column-fill, column-gap, column-rule, column-rule-color, column-rule-style, column-rule-width, column-span, column-width, columns, crop, display-model, display-role, dominant-baseline, drop-initial-after-adjust, drop-initial-after-align, drop-initial-before-adjust, drop-initial-before-align, drop-initial-size, drop-initial-value, fit, fit-position, float-offset, font-effect, font-emphasize, font-emphasize-position, font-emphasize-style, font-size-adjust, font-smooth, font-stretch, grid-columns, grid-rows, hanging-punctuation, hyphenate-after, hyphenate-before, hyphenate-character, hyphenate-lines, hyphenate-resource, hyphens, icon, image-orientation, image-resolution, inline-box-align, line-stacking, line-stacking-ruby, line-stacking-shift, line-stacking-strategy, mark, mark-after, mark-before, marker-offset, marks, marquee-direction, marquee-play-count, marquee-speed, marquee-style, move-to, nav-down, nav-index, nav-left, nav-right, nav-up, opacity, outline-offset, overflow-style, overflow-x, overflow-y, page, page-policy, phonemes, presentation-level, punctuation-trim, rendering-intent, resize, rest, rest-after, rest-before, rotation, rotation-point, ruby-align, ruby-overhang, ruby-position, ruby-span, size, string-set, tab-side, target, target-name, target-new, target-position, text-align-last, text-emphasis, text-height, text-justify, text-outline, text-replace, text-shadow, text-wrap, voice-balance, voice-duration, voice-pitch, voice-pitch-range, voice-rate, voice-stress, voice-volume, white-space-collapse, word-break, word-wrap",alias:"kw2"},values:{csv:"100, 200, 300, 400, 500, 600, 700, 800, 900, above, absolute, always, aqua, armenian, auto, avoid, baseline, below, bidi-override, black, blink, block, blue, bold, bolder, both, bottom, break-all, break-strict, break-word, break, capitalize, caption, center, circle, cjk-ideographic, close-quote, collapse, compact, condensed, crop, cross, crosshair, dashed, decimal-leading-zero, decimal, default, disc, dotted, double, e-resize, embed, expanded, extra-condensed, extra-expanded, fixed, fuchsia, georgian, gray, green, groove, hand, hebrew, help, hidden, hide, higher, hiragana-iroha, hiragana, icon, inherit, inline-table, inline, inset, inside, invert, italic, justify, katakana-iroha, katakana, keep-all, konq-center, landscape, large, larger, left, level, light, lighter, lime, line-through, list-item, loose, loud, lower-alpha, lower-greek, lower-latin, lower-roman, lowercase, lower, ltr, marker, maroon, medium, menu, message-box, middle, mix, move, n-resize, narrower, navy, ne-resize, never, no-close-quote, no-open-quote, no-repeat, none, normal, nowrap, nw-resize, oblique, olive, open-quote, outset, outside, overline, pointer, portrait, pre-wrap, pre, purple, red, relative, repeat, repeat-x, repeat-y, ridge, right, rtl, run-in, s-resize, scroll, se-resize, semi-condensed, semi-expanded, separate, show, silver, small-caps, small-caption, smaller, small, solid, square, static-position, static, status-bar, sub, super, sw-resize, table-caption, table-cell, table-column-group, table-column, table-footer-group, table-header-group, table-row, table-row-group, table, teal, text-bottom, text-top, text, thick, thin, top, transparent, ultra-condensed, ultra-expanded, underline, upper-alpha, upper-latin, upper-roman, uppercase, visible, w-resize, wait, white, wider, x-large, x-small, xx-large, xx-small, yellow",alias:"kw3"}});this.patterns=new Hash({multiComments:{pattern:this.common.multiComments,alias:"co1"},strings:{pattern:this.common.strings,alias:"st0"},selectors:{pattern:/([^\}\n]+)\{/gi,alias:"se0"},uri:{pattern:/url\s*\([^\)]*\)/gi,alias:"kw4"},units:{pattern:/\b(\d+[\.\d+]?\s*(px|pt|em|ex|cm|in|mm|pc|%)?)/gi,alias:"nu0"},hexColors:{pattern:/(#[A-F0-9]{3}([A-F0-9]{3})?)\b/gi,alias:"kw3"},rgbColors:{pattern:/(rgb\s*\(([1-2]?[0-9]{2}(\,\s*)?){3}\))/g,alias:"kw3"}});this.delimiters=new Hash({start:this.strictRegExp('<style type="text/css">'),end:this.strictRegExp("</style>")});this.parent(a,c,b)}});
Fuel.php=new Class({Extends:Fuel,language:"php",initialize:function(a,d,c,b){this.keywords=new Hash({keywords:{csv:"abstract, and, as, break, case, catch, cfunction, class, clone, const, continue, declare, default, do, else, elseif, enddeclare, endfor, endforeach, endif, endswitch, endwhile, extends, final, for, foreach, function, global, goto, if, implements, interface, instanceof, namespace, new, old_function, or, private, protected, public, static, switch, throw, try, use, var, while, xor",alias:"kw1"},langConstants:{csv:"__CLASS__, __DIR__, __FILE__, __FUNCTION__, __METHOD__, __NAMESPACE__, DEFAULT_INCLUDE_PATH, E_ALL, E_COMPILE_ERROR, E_COMPILE_WARNING, E_CORE_ERROR, E_CORE_WARNING, E_ERROR, E_NOTICE, E_PARSE, E_STRICT, E_USER_ERROR, E_USER_NOTICE, E_USER_WARNING, E_WARNING, PEAR_EXTENSION_DIR, PEAR_INSTALL_DIR, PHP_BINDIR, PHP_CONFIG_FILE_PATH, PHP_DATADIR, PHP_EXTENSION_DIR, PHP_LIBDIR, PHP_LOCALSTATEDIR, PHP_OS, PHP_OUTPUT_HANDLER_CONT, PHP_OUTPUT_HANDLER_END, PHP_OUTPUT_HANDLER_START, PHP_SYSCONFDIR, PHP_VERSION",alias:"kw1"},constructs:{csv:"array, die, echo, empty, exit, eval, include, include_once, isset, list, require, require_once, return, print, unset",alias:"kw1"},commonFuncs:{csv:"abs, addcslashes, addslashes, aggregate, apache_child_terminate, apache_get_version, apache_lookup_uri, apache_note, apache_request_headers, apache_response_headers, apache_setenv, array_change_key_case, array_chunk, array_count_values, array_diff, array_diff_assoc, array_fill, array_filter, array_flip, array_intersect, array_intersect_assoc, array_key_exists, array_keys, array_map, array_merge, array_merge_recursive, array_multisort, array_pad, array_pop, array_push, array_rand, array_reduce, array_reverse, array_search, array_shift, array_slice, array_splice, array_sum, array_unique, array_unshift, array_values, array_walk, arsort, asort, assert, assert_options, base64_decode, base64_encode, base_convert, basename, bin2hex, bindec, ceil, chdir, checkdate, chop, chown, chunk_split, clearstatcache, closedir, compact, connection_aborted, connection_status, constant, copy, count, count_chars, crc32, crypt, ctype_alnum, ctype_alpha, ctype_cntrl, ctype_digit, ctype_graph, ctype_lower, ctype_print, ctype_punct, ctype_space, ctype_upper, ctype_xdigit, current, date, debug_backtrace, debug_zval_dump, decbin, dechex, decoct, define, defined, dir, dirname, dl, doubleval, each, end, ereg, ereg_replace, eregi, eregi_replace, error_log, error_reporting, escapeshellarg, escapeshellcmd, exec, explode, extension_loaded, extract, fclose, feof, fflush, fgetc, fgetcsv, fgets, fgetss, file, file_exists, file_get_contents, fileatime, filectime, filegroup, fileinode, filemtime, fileowner, fileperms, filesize, filetype, floatval, flock, floor, flush, fmod, fnmatch, fopen, fpassthru, fputs, fread, fscanf, fseek, fsockopen, fstat, ftell, ftok, ftruncate, func_get_arg, func_get_args, func_num_args, fwrite, get_browser, get_cfg_var, get_declared_classes, get_extension_funcs, get_include_path, get_loaded_extensions, get_magic_quotes_gpc, get_magic_quotes_runtime, get_meta_tags, getallheaders, getcwd, getdate, getenv, getimagesize, getopt, getrandmax, getrusage, gettimeofday, gettype, glob, global, gmdate, gmmktime, gmstrftime, header, headers_sent, hebrev, hebrevc, hexdec, highlight_file, highlight_string, html_entity_decode, htmlentities, htmlspecialchars, ignore_user_abort, image_type_to_mime_type, implode, import_request_variables, in_array, ini_alter, ini_get, ini_get_all, ini_restore, ini_set, intval, ip2long, is_array, is_bool, is_dir, is_double, is_executable, is_file, is_finite, is_float, is_infinite, is_int, is_integer, is_link, is_long, is_nan, is_null, is_numeric, is_object, is_readable, is_real, is_resource, is_scalar, is_string, is_uploaded_file, is_writable, is_writeable, join, key, key_exists, krsort, ksort, link, linkinfo, localeconv, localtime, long2ip, lstat, ltrim, magic_quotes_runtime, mail, max, md5, md5_file, memory_get_usage, microtime, min, mkdir, mktime, move_uploaded_file, mt_getrandmax, mt_rand, mt_srand, natcasesort, natsort, next, nl2br, number_format, ob_clean, ob_end_clean, ob_end_flush, ob_flush, ob_get_clean, ob_get_contents, ob_get_flush, ob_get_length, ob_get_level, ob_get_status, ob_implicit_flush, ob_list_handlers, ob_start, octdec, opendir, overload, pack, parse_ini_file, parse_str, parse_url, passthru, pathinfo, pclose, pfsockopen, pg_affected_rows, pg_cancel_query, pg_client_encoding, pg_close, pg_cmdtuples, pg_connect, pg_connection_busy, pg_connection_reset, pg_connection_status, pg_convert, pg_copy_from, pg_copy_to, pg_dbname, pg_delete, pg_end_copy, pg_errormessage, pg_escape_bytea, pg_escape_string, pg_exec, pg_fetch_all, pg_fetch_array, pg_fetch_assoc, pg_fetch_object, pg_fetch_result, pg_fetch_row, pg_field_is_null, pg_field_name, pg_field_num, pg_field_prtlen, pg_field_size, pg_field_type, pg_fieldisnull, pg_fieldname, pg_fieldnum, pg_fieldprtlen, pg_fieldsize, pg_fieldtype, pg_free_result, pg_freeresult, pg_get_notify, pg_get_pid, pg_get_result, pg_getlastoid, pg_host, pg_insert, pg_last_error, pg_last_notice, pg_last_oid, pg_lo_close, pg_lo_create, pg_lo_export, pg_lo_import, pg_lo_open, pg_lo_read, pg_lo_read_all, pg_lo_seek, pg_lo_tell, pg_lo_unlink, pg_lo_write, pg_loclose, pg_locreate, pg_loexport, pg_loimport, pg_loopen, pg_loread, pg_loreadall, pg_lounlink, pg_lowrite, pg_meta_data, pg_num_fields, pg_num_rows, pg_numfields, pg_numrows, pg_options, pg_pconnect, pg_ping, pg_port, pg_put_line, pg_query, pg_result, pg_result_error, pg_result_seek, pg_result_status, pg_select, pg_send_query, pg_set_client_encoding, pg_trace, pg_tty, pg_unescape_bytea, pg_untrace, pg_update, phpcredits, phpinfo, phpversion, popen, pos, preg_grep, preg_match, preg_match_all, preg_quote, preg_replace, preg_replace_callback, preg_split, prev, print_r, printf, proc_close, proc_open, putenv, quoted_printable_decode, quotemeta, rand, range, rawurldecode, rawurlencode, readdir, readfile, readlink, realpath, rename, reset, restore_error_handler, restore_include_path, rewind, rewinddir, rmdir, round, rsort, rtrim, serialize, session_cache_expire, session_cache_limiter, session_decode, session_destroy, session_encode, session_get_cookie_params, session_id, session_is_registered, session_module_name, session_name, session_regenerate_id, session_register, session_save_path, session_set_cookie_params, session_set_save_handler, session_start, session_unregister, session_unset, session_write_close, set_error_handler, set_file_buffer, set_include_path, set_magic_quotes_runtime, set_socket_blocking, set_time_limit, setcookie, setlocale, settype, shell_exec, show_source, shuffle, similar_text, sizeof, sleep, socket_get_status, socket_set_blocking, socket_set_timeout, sort, split, spliti, sprintf, sql_regcase, srand, sscanf, stat, static, str_pad, str_repeat, str_replace, str_rot13, str_shuffle, str_word_count, strcasecmp, strchr, strcmp, strcoll, strcspn, stream_context_create, stream_context_get_options, stream_context_set_option, stream_context_set_params, stream_filter_append, stream_filter_prepend, stream_get_meta_data, stream_register_wrapper, stream_select, stream_set_blocking, stream_set_timeout, stream_set_write_buffer, stream_wrapper_register, strftime, strip_tags, stripcslashes, stripslashes, stristr, strlen, strnatcasecmp, strnatcmp, strncasecmp, strncmp, strpos, strrchr, strrev, strrpos, strspn, strstr, strtok, strtolower, strtotime, strtoupper, strtr, strval, substr, substr_count, substr_replace, system, tempnam, time, tmpfile, touch, trigger_error, trim, uasort, ucfirst, ucwords, uksort, umask, uniqid, unlink, unpack, unserialize, urldecode, urlencode, user_error, usleep, usort, var_dump, var_export, version_compare, virtual, vprintf, vsprintf, wordwrap",alias:"kw2"},database:{csv:"mysql, mysql_affected_rows, mysql_client_encoding, mysql_close, mysql_connect, mysql_create_db, mysql_createdb, mysql_data_seek, mysql_db_name, mysql_db_query, mysql_dbname, mysql_drop_db, mysql_dropdb, mysql_errno, mysql_error, mysql_escape_string, mysql_fetch_array, mysql_fetch_assoc, mysql_fetch_field, mysql_fetch_lengths, mysql_fetch_object, mysql_fetch_row, mysql_field_flags, mysql_field_len, mysql_field_name, mysql_field_seek, mysql_field_table, mysql_field_type, mysql_fieldflags, mysql_fieldlen, mysql_fieldname, mysql_fieldtable, mysql_fieldtype, mysql_free_result, mysql_freeresult, mysql_get_client_info, mysql_get_host_info, mysql_get_proto_info, mysql_get_server_info, mysql_info, mysql_insert_id, mysql_list_dbs, mysql_list_fields, mysql_list_processes, mysql_list_tables, mysql_listdbs, mysql_listfields, mysql_listtables, mysql_num_fields, mysql_num_rows, mysql_numfields, mysql_numrows, mysql_pconnect, mysql_query, mysql_real_escape_string, mysql_result, mysql_select_db, mysql_selectdb, mysql_stat, mysql_table_name, mysql_tablename, mysql_thread_id, mysql_unbuffered_query, mysqli, mysqli_affected_rows, mysqli_autocommit, mysqli_bind_param, mysqli_bind_result, mysqli_change_user, mysqli_character_set_name, mysqli_client_encoding, mysqli_close, mysqli_commit, mysqli_connect, mysqli_data_seek, mysqli_debug, mysqli_disable_reads_from_master, mysqli_disable_rpl_parse, mysqli_dump_debug_info, mysqli_enable_reads_from_master, mysqli_enable_rpl_parse, mysqli_errno, mysqli_error, mysqli_escape_string, mysqli_execute, mysqli_fetch, mysqli_fetch_array, mysqli_fetch_assoc, mysqli_fetch_field, mysqli_fetch_field_direct, mysqli_fetch_fields, mysqli_fetch_lengths, mysqli_fetch_object, mysqli_fetch_row, mysqli_field_count, mysqli_field_seek, mysqli_field_tell, mysqli_free_result, mysqli_get_client_info, mysqli_get_host_info, mysqli_get_proto_info, mysqli_get_server_info, mysqli_get_server_version, mysqli_info, mysqli_init, mysqli_insert_id, mysqli_kill, mysqli_master_query, mysqli_num_fields, mysqli_num_rows, mysqli_options, mysqli_param_count, mysqli_ping, mysqli_prepare, mysqli_prepare_result, mysqli_profiler, mysqli_query, mysqli_read_query_result, mysqli_real_connect, mysqli_real_escape_string, mysqli_real_query, mysqli_reload, mysqli_rollback, mysqli_rpl_parse_enabled, mysqli_rpl_probe, mysqli_rpl_query_type, mysqli_select_db, mysqli_send_long_data, mysqli_send_query, mysqli_set_opt, mysqli_slave_query, mysqli_ssl_set, mysqli_stat, mysqli_stmt_affected_rows, mysqli_stmt_close, mysqli_stmt_errno, mysqli_stmt_error, mysqli_stmt_store_result, mysqli_store_result, mysqli_thread_id, mysqli_thread_safe, mysqli_use_result, mysqli_warning_count",alias:"kw2"}}),this.patterns=new Hash({slashComments:{pattern:this.common.slashComments,alias:"co1"},multiComments:{pattern:this.common.multiComments,alias:"co2"},strings:{pattern:this.common.strings,alias:"st0"},heredocs:{pattern:/(<<<\s*?(\'?)([A-Z0-9]+)\2[^\n]*?\n[\s\S]*?\n\3(?![A-Z0-9\s]))/gim,alias:"st1"},numbers:{pattern:/\b((([0-9]+)?\.)?[0-9_]+([e][-+]?[0-9]+)?|0x[A-F0-9]+)\b/gi,alias:"nu0"},variables:{pattern:/[\$]{1,2}[A-Z_][\w]*/gim,alias:"kw3"},functions:{pattern:this.common.functionCalls,alias:"me0"},constants:{pattern:/\b[A-Za-z_][\w]*\b/g,alias:"kw4"},methods:{pattern:/->([\w]+)/gim,alias:"kw3"},brackets:{pattern:this.common.brackets,alias:"br0"},});this.delimiters=new Hash({start:this.strictRegExp("<?php","<?=","<%",'<script language="php">'),end:this.strictRegExp("?>","%>","<\/script>")});this.parent(a,d,c,b)}});
Fuel.ruby=new Class({Extends:Fuel,language:"ruby",initialize:function(a,c,b){this.keywords=new Hash({reserved:{csv:"__FILE__, __LINE__, alias, and, BEGIN, begin, break, case, class, def, defined, do, else, elsif, END, end, ensure, false, for, if, in, module, next, nil, not, or, redo, rescue, retry, return, self, super, then, true, undef, unless, until, when, while, yield",alias:"kw1"},functions:{csv:"abort, at_exit, autoload, binding, block_given, callcc, caller, catch, chomp, chop, eval, exec, exit, exit!, fail, fork, format, gets, global_variables, gsub, lambda, proc, load, local_variables, loop, open, p, print, proc, putc, puts, raise, fail, rand, readline, readlines, require, scan, select, set_trace_func, sleep, split, sprintf, format, srand, syscall, system, sub, test, throw, trace_var, trap, untrace_var",alias:"kw2"},classes:{csv:"Abbrev, ArgumentError, Array, Base64, Benchmark, Benchmark::Tms, Bignum, Binding, CGI, Cookie, HtmlExtension, QueryExtension, Session, FileStore, MemoryStore, Class, Comparable, Complex, ConditionVariable, Continuation, Data, Date, DateTime, Dir, EOFError, Enumerable, Errno, Exception, FalseClass, File, Constants, Stat, FileTest, FileUtils, CopyContext_, DryRun, NoWrite, Verbose, Find, Fixnum, Float, FloatDomainError, GC, Generator, Hash, IO, IOError, Iconv, Failure, IllegalSequence, InvalidCharacter, OutOfRange, IndexError, Integer, Interrupt, Kernel, LoadError, LocalJumpError, Logger, Application, LogDevice, Severity, ShiftingError, Marshal, MatchData, Math, Matrix, Method, Module, Mutex, NameError, NilClass, NoMemoryError, NoMethodError, NotImplementedError, Numeric, Object, ObjectSpace, Observable, Pathname, Precision, Proc, Process, GID, Status, Sys, UID, Queue, Range, RangeError, Regexp, RegexpError, RuntimeError, ScriptError, SecurityError, Set, Shellwords, Signal, SignalException, Singleton, SingletonClassMethods, SizedQueue, SortedSet, StandardError, String, StringScanner, StringScanner::Error, Struct, Symbol, SyncEnumerator, SyntaxError, SystemCallError, SystemExit, SystemStackError, Tempfile, Test, Unit, Thread, ThreadError, ThreadGroup, ThreadsWait, Time, TrueClass, TypeError, UnboundMethod, Vector, YAML, ZeroDivisionError, Zlib, BufError, DataError, Deflate, Error, GzipFile, CRCError, Error, LengthError, NoFooter, GzipReader, GzipWriter, Inflate, MemError, NeedDict, StreamEnd, StreamError, VersionError, ZStream, fatal",alias:"kw2"}}),this.patterns=new Hash({poundComments:{pattern:this.common.poundComments,alias:"co1"},multiComments:{pattern:/^=begin[\s\S]*?^=end/gm,alias:"co2"},strings:{pattern:this.common.strings,alias:"st0"},tickStrings:{pattern:this.delimToRegExp("`","\\","`","gm"),alias:"st0"},delimString:{pattern:/(%[q|Q|x]?(\W)[^\2\\\n]*(?:\\.[^\2\\]*)*(\2|\)|\]|\}))/gm,alias:"st1"},heredoc:{pattern:/(<<(\'?)([A-Z0-9]+)\2[^\n]*?\n[\s\S]*\n\3(?![\w]))/gim,alias:"st2"},variables:{pattern:/(@[A-Za-z_][\w]*|@@[A-Za-z_][\w]*|\$(?:\-[\S]|[\w]+)|\b[A-Z][\w]*)/g,alias:"kw3"},rubySymbols:{pattern:/[^:](:[\w]+)/g,alias:"kw4"},constants:{pattern:/\b[A-Z][\w]*/g,alias:"kw3"},numbers:{pattern:/\b((([0-9]+)?\.)?[0-9_]+([e][-+]?[0-9]+)?|0x[A-F0-9]+|0b[0-1_]+)\b/gim,alias:"nu0"},properties:{pattern:this.common.properties,alias:"me0"},brackets:{pattern:this.common.brackets,alias:"br0"},delimRegex:{pattern:/(%r(\W)[^\2\\\n]*(?:\\.[^\2\\\n]*?)*(\2|\)|\]|\})[iomx]*)/gm,alias:"re0"},literalRegex:{pattern:this.delimToRegExp("/","\\","/","g","[iomx]*"),alias:"re0"}});this.parent(a,c,b)}});
Flame.panic=new Class({Extends:Flame,shortName:"panic",styles:new Hash({de1:new Hash({color:"#A00083"}),de2:new Hash({color:"#A00083"}),kw1:new Hash({color:"#9F0050"}),kw2:new Hash({color:"#9F0050"}),kw3:new Hash({color:"#EF7300"}),kw4:new Hash({color:"#9F0050"}),co1:new Hash({color:"#00721F","font-style":"italic"}),co2:new Hash({color:"#00721F","font-style":"italic"}),st0:new Hash({color:"#8A000F"}),st1:new Hash({color:"#8A000F"}),st2:new Hash({color:"#8A000F"}),nu0:new Hash({color:"#1600FF"}),me0:new Hash({color:"#000"}),br0:new Hash({color:"#000"}),sy0:new Hash({color:"#000"}),es0:new Hash({color:"#000"}),re0:new Hash({color:"#8A000F"})}),common:new Hash(),layout:new Hash({numBgColor:new Hash({"background-color":"#f2f2f2"}),lineBgColor:new Hash({"background-color":"#fff"}),lineNumStyles:new Hash({color:"#939393","font-size":"10px","list-style":"decimal-leading-zero"}),lineStyles:new Hash({"border-top":"1px solid #fff","border-bottom":"1px solid #fff","border-left":"1px solid #939393",padding:"0 3px 0 10px"}),altLineStyles:new Hash({"border-top":"1px solid #eee","border-bottom":"1px solid #eee","background-color":"#F4F8FC"}),top:new Hash({"padding-top":"5px"}),right:new Hash({"padding-right":"5px"}),bottom:new Hash({"padding-bottom":"5px"}),left:new Hash({"padding-left":"15px"}),codeStyles:new Hash({color:"black","font-size":"12px"})}),initialize:function(a,b){this.parent(a,b)}});
Flame.twilight=new Class({Extends:Flame,shortName:"twilight",styles:new Hash({de1:new Hash({color:"#fff"}),de2:new Hash({color:"#fff"}),kw1:new Hash({color:"#CDA869"}),kw2:new Hash({color:"#F9EE98"}),kw3:new Hash({color:"#6F87A8"}),kw4:new Hash({color:"#E96546"}),co1:new Hash({color:"#5F5A60"}),co2:new Hash({color:"#5F5A60"}),st0:new Hash({color:"#8F9657"}),st1:new Hash({color:"#8F9657"}),st2:new Hash({color:"#8F9657"}),nu0:new Hash({color:"#CF6745"}),me0:new Hash({color:"#fff"}),br0:new Hash({color:"#fff"}),sy0:new Hash({color:"#fff"}),es0:new Hash({color:"#fff"}),re0:new Hash({color:"#E57A27"})}),common:new Hash({border:"1px solid #222",color:"#f8f8f8","font-family":"Monaco, Courier, monospace","font-size":"12px","line-height":"1.6em"}),layout:new Hash({numBgColor:new Hash({"background-color":"#f2f2f2"}),lineBgColor:new Hash({"background-color":"#141414"}),lineNumStyles:new Hash({color:"#000","font-size":"10px"}),lineStyles:new Hash({"border-left":"1px solid #939393"}),codeStyles:new Hash({"font-size":"12px",color:"#f8f8f8"}),altLineStyles:new Hash({"background-color":"#202021"}),top:new Hash({"padding-top":"10px"}),right:new Hash({"padding-right":"5px"}),bottom:new Hash({"padding-bottom":"10px"}),left:new Hash({"padding-left":"15px"})}),initialize:function(a,b){this.parent(a,b)}});
Flame.git=new Class({Extends:Flame,shortName:"git",styles:new Hash({de1:new Hash({color:"#CF6A4C"}),de2:new Hash({color:"#CF6A4C"}),kw1:new Hash({color:"#000","font-weight":"bold"}),kw2:new Hash({color:"#0086b3"}),kw3:new Hash({color:"#445588","font-weight":"bold"}),kw4:new Hash({color:"#990073"}),co1:new Hash({color:"#999988","font-style":"italic"}),co2:new Hash({color:"#999988","font-style":"italic"}),st0:new Hash({color:"#dd1144"}),st1:new Hash({color:"#dd1144"}),st2:new Hash({color:"#dd1144"}),nu0:new Hash({color:"#009999"}),me0:new Hash({color:"#0086b3"}),br0:new Hash({color:"#777"}),sy0:new Hash({color:"#777"}),es0:new Hash({color:"#777"}),re0:new Hash({color:"#009926"})}),common:new Hash({"border-bottom":"1px solid #eee","border-top":"1px solid #eee",color:"#939393","font-family":"Courier, monospace","line-height":"1.6em"}),layout:new Hash({numBgColor:new Hash({"background-color":"#f2f2f2"}),lineBgColor:new Hash({"background-color":"#fff"}),lineNumStyles:new Hash({color:"#aaa","font-size":"10px"}),lineStyles:new Hash({"border-left":"1px solid #939393"}),altLineStyles:new Hash({"background-color":"#ffffcc"}),top:new Hash({"padding-top":"10px"}),right:new Hash({"padding-right":"5px"}),bottom:new Hash({"padding-bottom":"10px"}),left:new Hash({"padding-left":"15px"}),codeStyles:new Hash({"font-size":"12px",color:"#000"})}),initialize:function(d,c){this.parent(d,c)}});